/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.gui.calendar.Appointment;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.calendar.ReminderAppointment;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.ReminderService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ReminderAppointmentProvider
implements AppointmentProvider {
    @Override
    public List<Appointment> getAppointments(Date from, Date to) {
        try {
            ReminderService service = (ReminderService)Application.getBootLoader().getBootable(ReminderService.class);
            ReminderStorageProvider provider = service.getDefaultProvider();
            Map<String, Reminder> reminders = provider.find("jameica.reminder.appointment", from, to);
            Iterator<String> uuids = reminders.keySet().iterator();
            LinkedList<Appointment> result = new LinkedList<Appointment>();
            while (uuids.hasNext()) {
                String uuid = uuids.next();
                Reminder reminder = reminders.get(uuid);
                ReminderInterval ri = reminder.getReminderInterval();
                if (ri == null) {
                    result.add(new ReminderAppointment(uuid, reminder));
                    continue;
                }
                Date end = reminder.getEnd();
                List<Date> dates = ri.getDates(reminder.getDate(), from, to);
                for (Date d : dates) {
                    if (end != null && !end.after(to)) continue;
                    result.add(new ReminderAppointment(uuid, reminder, d));
                }
            }
            return result;
        }
        catch (Exception e) {
            Logger.error((String)"unable to load data", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return Application.getI18n().tr("Erinnerungen");
    }
}

